/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.categories;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.client.SoundEventRegistry;
import com.github.charlyb01.music_control.mixin.SoundSetAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1111;
import net.minecraft.class_1148;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class MusicCategories {
    public static final ArrayList<String> CATEGORIES = new ArrayList<String>(Arrays.asList("all", "default", "disc"));
    public static final ArrayList<String> NAMESPACES = new ArrayList<String>(List.of("minecraft"));
    public static final LinkedList<class_2960> PLAYED_MUSICS = new LinkedList();

    private MusicCategories() {
    }

    public static void init(class_310 client) {
        if (MusicControlClient.init) {
            PLAYED_MUSICS.clear();
            Music.MUSIC_BY_NAMESPACE.clear();
            Music.MUSIC_BY_EVENT.clear();
            Music.EVENTS.clear();
            SoundEventRegistry.BIOME_MUSIC_MAP.clear();
        } else {
            MusicControlClient.init = true;
        }
        class_5819 random = class_5819.method_43053();
        HashSet<Music> musics = new HashSet<Music>();
        HashSet<Music> discs = new HashSet<Music>();
        Music.MUSIC_BY_NAMESPACE.put("all", musics);
        Music.MUSIC_BY_NAMESPACE.put("disc", discs);
        for (class_3414 soundEvent : class_7923.field_41172) {
            class_5321<class_1959> biomeRegistryKey;
            String[] split;
            class_2960 event = soundEvent.method_14833();
            if (!event.method_12832().contains("music")) continue;
            if (!Music.EVENTS.contains(event) && !Music.BLACK_LISTED_EVENTS.contains(event)) {
                Music.EVENTS.add(event);
                Music.MUSIC_BY_EVENT.put(event, new HashSet());
            }
            if ((split = event.method_12832().split("\\.")).length <= 0 || (biomeRegistryKey = SoundEventRegistry.NAME_BIOME_MAP.get(class_2960.method_60655((String)event.method_12836(), (String)split[split.length - 1]))) == null) continue;
            SoundEventRegistry.BIOME_MUSIC_MAP.put(biomeRegistryKey, soundEvent);
        }
        for (class_2960 eventIdentifier : client.method_1483().method_4864()) {
            if (client.method_1483().method_4869(eventIdentifier) == null) continue;
            List<class_1148<class_1111>> sounds = ((SoundSetAccessor)client.method_1483().method_4869(eventIdentifier)).getSounds();
            String namespace = eventIdentifier.method_12836();
            String path = eventIdentifier.method_12832();
            if (!path.contains("music")) continue;
            for (class_1148<class_1111> soundContainer : sounds) {
                if (!(soundContainer instanceof class_1111)) continue;
                class_2960 musicIdentifier = ((class_1111)soundContainer.method_4893(random)).method_4767();
                Music music = new Music(musicIdentifier);
                Optional<Music> optionalMusic = musics.stream().filter(music1 -> music1.getIdentifier().equals((Object)musicIdentifier)).findAny();
                if (optionalMusic.isPresent()) {
                    music = optionalMusic.get();
                    music.addEvent(eventIdentifier);
                    continue;
                }
                if (path.contains("music_disc")) {
                    discs.add(music);
                }
                musics.add(music);
                music.addEvent(eventIdentifier);
                if (namespace.equals("minecraft")) continue;
                HashSet customMusics = Music.MUSIC_BY_NAMESPACE.computeIfAbsent(namespace, k -> new HashSet());
                customMusics.add(music);
                if (CATEGORIES.contains(namespace)) continue;
                CATEGORIES.add(namespace);
                NAMESPACES.add(namespace);
            }
        }
        if (!CATEGORIES.contains(MusicControlClient.currentCategory)) {
            MusicControlClient.currentCategory = "default";
        }
    }

    public static void changeCategory(boolean nextCategory) {
        int index;
        int n = index = nextCategory ? (CATEGORIES.indexOf(MusicControlClient.currentCategory) + 1) % CATEGORIES.size() : CATEGORIES.indexOf(MusicControlClient.currentCategory) - 1;
        if (index < 0) {
            index = CATEGORIES.size() - 1;
        }
        MusicControlClient.currentCategory = CATEGORIES.get(index);
    }
}

